<?php

namespace Unique\UserBundle\Security;

use Symfony\Component\Security\Core\Exception\CustomUserMessageAuthenticationException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * User Checker.
 *
 * @author Lukas Krchnak <lukas.krchnak@uniqueweb.cz>
 */
class UserChecker implements UserCheckerInterface
{
    public function checkPreAuth(UserInterface $user): void
    {

        // Frozen Account
        if ($user->isFreeze()) {
            throw new CustomUserMessageAuthenticationException('The account has been suspended');
        }

        // Activate Account
        if (!$user->isActive()) {
            throw new CustomUserMessageAuthenticationException('Account has not been activated');
        }
    }

    public function checkPostAuth(UserInterface $user): void
    {
        if (!$user instanceof UserInterface) {
            return;
        }
    }
}
