<?php

declare(strict_types=1);

namespace App\Entity\EventLog;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'log_event_source')]
#[ORM\Entity]
class EventSource
{

    final public const APP_DAEMON = 1;
    final public const APP_WEBUI = 2;

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 32, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'source', targetEntity: EventLog::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $events;

    /**
     * EventSource constructor
     */
    public function __construct(){

        $this->events = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

}