<?php

declare(strict_types=1);

namespace App\Entity\Types;

use App\Entity\Device;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'liveness_time')]
#[ORM\Entity]
class LivenessTime
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false)]
    public string $description;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'liveTime', targetEntity: Device\DeviceStats::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devicesStats;

    /**
     * LivenessTime constructor
     */
    public function __construct(){

        $this->devicesStats = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getDescription(): string {

        return $this->description;

    }

}