<?php

namespace App\Repository;

use App\Entity\DeviceSyncStatus;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method DeviceSyncStatus|null find($id, $lockMode = null, $lockVersion = null)
 * @method DeviceSyncStatus|null findOneBy(array $criteria, array $orderBy = null)
 * @method DeviceSyncStatus[]    findAll()
 * @method DeviceSyncStatus[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DeviceSyncStatusRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, DeviceSyncStatus::class);
    }

    public function getBeingProcessedStatus(){

        return $this->findOneBy(['id' => DeviceSyncStatus::BEING_PROCESSED]);

    }

}
