<?php

namespace App\DBALType;

use App\ValueObject\Configuration;
use Doctrine\DBAL\Types\Type;
use Doctrine\DBAL\Platforms\AbstractPlatform;

/**
 * App Configuration type
 *
 * @author Lukas Krchnak <lukas_krchnak@uniqueweb.cz>
 */
class ConfigurationDBALType extends Type
{
    const CONFIG_VALUE = 'app_config';

    /**
     * @param array $fieldDeclaration
     * @param AbstractPlatform $platform
     *
     * @return string
     */
    public function getSQLDeclaration(array $fieldDeclaration, AbstractPlatform $platform){

        return 'ENUM("' . implode('","', Configuration::getPossibleValues()) . '")';

    }

    /**
     * @param string $type
     * @param AbstractPlatform $platform
     *
     * @return Configuration
     */
    public function convertToPHPValue($type, AbstractPlatform $platform){

        return Configuration::fromString($type);

    }

    /**
     * @param Configuration $status
     * @param AbstractPlatform $platform
     *
     * @return string
     */
    public function convertToDatabaseValue($value, AbstractPlatform $platform){

        return (string) $value;

    }

    /**
     * @return string
     */
    public function getName(){

        return self::CONFIG_VALUE;

    }

}