#!/bin/bash

BASEDEFS="base_defs"

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR"/"$BASEDEFS" || { echo "Fatal: Definition file ($BASEDEFS) not found."; exit 1; }
. "$DIR"/"$BASEFUNCS" || { echo "Fatal: Basic functions ($BASEFUNCS) not found."; exit 1; }

HLP="
	This script logs $NAME event into DB with fixed source ($NAME Script)

	You need to provide event type (a number only) and potentially also optional arguments:
	VAL=<integer value> ... being stored as event value (just number, no '<' and '>')
	MSG=\"Your message\" ... geing stored as event comment
	EID=<integer value> ... extra number (again, without '<' and '>')

	A list of allowed events follows:
	"

printhelpexit() {
	echo -e "$HLP" >&2
	events_get_verbose >&2
	exit 1
}

[ $# -ge 1 ] || printhelpexit
event_log "$@"
