<?php

namespace App\Datatables;

use App\Entity\VDevice;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\MultiselectColumn;

/**
 * Class DeviceInMonitoringGroupDatatable
 * @package App\Datatables
 */
class DeviceInMonitoringGroupDatatable extends DeviceDatatable
{

    protected string $entity = VDevice::class;
    protected string $name = 'device_monitoring_group_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = [], bool $parentCall = false): void
    {

        $monitoringGroupId = $options['monitoringGroupId'];

        parent::buildDatatable($options, true);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/monitoringGroup/addDeviceToGroupModal.js.twig',
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addDevice',
                        'text' => '<i class=\"fa fa-plus\"></i> Add Device',
                        'enabled' => ($options['monitoringGroupId'] !== 1)  ? true: false,
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        if($options['monitoringGroupId'] !== 1){

            $actions[] = $this->getMonitoringGroupDevicesRemoveAction($monitoringGroupId);
            
        }
        $actions[] = $this->getAssignLabelsAction();
        $actions[] = $this->getAssignFwVersion();
        $actions[] = $this->getAssignConfigProfile();
        $actions[] = $this->getAssignAgentProfile();
        $actions[] = $this->getRemoveConfigProfile();

        $this->getMultiselectActions($actions, $options);

        //unset MonitoringGroups Column does not make sense in this table
        $key = array_search('MonitoringGroups', $this->columns);
        if ($key !== false) {
            unset($this->columns[$key]);
        }

        $this->getColumns($this->columns);

        $this->columnBuilder

            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.column_name'),
                'width' => '100%;',
                'class_name' => 'row_actions',
                'actions' => array(
                    array(
                        'route' => 'device_detail',
                        'route_parameters' => array(
                            'deviceId' => 'id',
                        ),
                        'label' => $this->translator->trans('sg.datatables.actions.detail'),
                        'icon' => self::ICON_DETAIL,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.detail'),
                            'class' => 'btn btn-primary btn-xs mb-1 mr-sm-2',
                            'role' => 'button',
                        ),
                    ),
                    array(
                        'route' => 'ajax_monitoring_group_device_remove',
                        'route_parameters' => array(
                            'monitoringGroupId' => $options['monitoringGroupId'],
                            'deviceId' => 'id',
                        ),
                        'label' => $this->translator->trans('sg.datatables.actions.removeFromGroup'),
                        'icon' => self::ICON_DELETE,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.removeFromGroup'),
                            'class' => 'btn btn-danger btn-xs mb-1',
                            'role' => 'button',
                            'data-toggle' => 'modal',
                            'id' => 'remove',
                            'data-target' => "#confirm-remove",
                        ),
                        'render_if' => function ($row) use($options) {
                            return $options['monitoringGroupId'] !== 1 && $this->authorizationChecker->isGranted('ROLE_ADMIN');
                        },
                    ),

                ),
            ))

        ;
    }

    public function getMultiselectActions(array $actions, array $options = []): void
    {

        $this->columnBuilder->add(null,MultiselectColumn::class, [

                'start_html' => '<div class="start_checkboxes">',
                'end_html' => '</div>',
                'width' => '10px',
                'add_if' => function () use ($options) {
                    return ($this->authorizationChecker->isGranted('ROLE_ADMIN') /*&& $options['monitoringGroupId'] !== 1*/); //Group All
                },
                'value' => 'id',
                'value_prefix' => false,
                //'render_actions_to_id' => 'sg-datatables-device_monitoring_group_datatable_wrapper',
                'actions' => $actions,

            ]

        );

    }

    private function getMonitoringGroupDevicesRemoveAction($monitoringGroupId): array {

        return [
            'route' => 'ajax_monitoring_group_devices_remove',
            'route_parameters' => ['monitoringGroupId' => $monitoringGroupId],
            'icon' => 'fa fa-trash',
            'label' => 'Remove from group',
            'attributes' => [
                'rel' => 'tooltip',
                'title' => 'remove',
                'class' => 'btn btn-danger btn-xs mb-1 mr-sm-2',
                'role' => 'button',
                'id' => '#confirm-remove-monitoring-groups-modal'
            ],
            //'confirm' => true,
            //'confirm_message' => 'Really?',
            //'start_html' => '<div class="start_delete_action">',
            'start_html' => '<div class="input-group">',
            //'end_html' => '</div>',
            'end_html' => '',
            'render_if' => function () {
                return $this->authorizationChecker->isGranted('ROLE_ADMIN');
            },
        ];

    }

}