<?php

declare(strict_types=1);

namespace App\Entity\Device;

use App\Entity\ConfigProfile;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'fwfnames')]
#[ORM\Entity]
class FwFileName
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, unique: true, nullable: false)]
    public string $name;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'osType', targetEntity: DeviceOsVersion::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $osVersions;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'fwfname', targetEntity: ConfigProfile\ConfigProfile::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $configProfiles;

    /**
     * FwFileName constructor
     */
    public function __construct() {

        $this->osVersions = new ArrayCollection();
        $this->configProfiles = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string{

        return $this->name;

    }

}