<?php

namespace App\Datatables\Column;

use Sg\DatatablesBundle\Datatable\Column\Column;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CustomMonitoringGroupArrayColumn extends Column
{

    protected $router;

    public function configureOptions(OptionsResolver $resolver)
    {

        parent::configureOptions($resolver);

        //Add new router option defined
        $resolver->setDefined(['router']);
        $resolver->setAllowedTypes('router', 'object');

    }

    /**
     * {@inheritdoc}
     */
    public function renderSingleField(array &$row)
    {
        $row[$this->data] = $this->arrayToString($row[$this->data] ?? []);

        return parent::renderSingleField($row);
    }

    /**
     * @param int $tab
     */
    protected function arrayToString( $array, $tab = 0): string
    {
        if(!is_array($array)){

            $array = explode(',', $array);
        }

        foreach ($array as $item){

            $data = explode('_', $item);
            $updated[$data[0]] = $data[1];

        }

        $array = $updated;

        $arrayField = '';
        $isArrayAssociative = $this->isAssociative($array);
        foreach ($array as $key => $arrayElement) {
            for ($i = 0; $i < $tab; ++$i) {
                $arrayField .= '&nbsp&nbsp';
            }

            if (\is_array($arrayElement)) {
                $arrayField .= '[<br/>';
                $arrayField .= $this->arrayToString($arrayElement, $tab + 1);
                $arrayField .= ']<br/>';

                continue;
            }

            if ($arrayElement instanceof \DateTime) {
                $arrayField .= $arrayElement->format('Y-m-d').'<br/>';

                continue;
            }

            $url = $this->router->generate('mntgrp_detail', ['monitoringGroupId' => $key]);
            if($key === 1){
                $arrayField .= '<a href="'.$url.'"><span class="badge badge-secondary" style="margin-right: 3px;">' . $arrayElement.'</span></a>';
            }else{
                $arrayField .= '<a href="'.$url.'"><span class="badge badge-success" style="margin-right: 3px;">' . $arrayElement.'</span></a>';
            }

        }

        return $arrayField;
    }

    protected function isAssociative(array $array): bool
    {
        if (empty($array)) {
            return false;
        }

        return array_keys($array) !== range(0, \count($array) - 1);
    }
}
