<?php

namespace App\Datatables\Column;

use Sg\DatatablesBundle\Datatable\Column\Column;

class CustomDeviceStatusColumn extends Column
{
    /**
     * {@inheritdoc}
     */
    public function renderSingleField(array &$row)
    {

        $status = $row['stats']['syncStatus']['description'];
        $statusId = $row['stats']['syncStatus']['id'];

        if($statusId === 3){ //Synchronized
            $color = 'green';
        }elseif($statusId === 5){ //Sync error
            $color = 'red';
        }else{
            $color = 'yellow';
        }

        $row['stats']['syncStatus']['description'] = '<i class="fa fa-circle '.$color.'" aria-hidden="true"></i> ' . $status;

        return parent::renderSingleField($row);
    }

}