<?php

declare(strict_types=1);

namespace App\Entity\DataChangeLog;

use App\Entity\DataChangeLog;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'data_atom')]
#[ORM\Entity]
class DataAtom
{
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    #[ORM\Column(type: Types::STRING, length: 64, unique: true, nullable: false)]
    public string $name;

    #[ORM\Column(type: Types::BOOLEAN, nullable: false)]
    public bool $visible;

	#[ORM\Column(type: Types::BOOLEAN, nullable: false)]
	public bool $logStream;

	#[ORM\Column(type: Types::BOOLEAN, nullable: false)]
	public bool $logDb;

	#[ORM\Column(type: Types::BOOLEAN, nullable: false)]
	public bool $logFile;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'atom', targetEntity: DataChangeLog\DataChangeLog::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $atoms;

    /**
     * EventSource constructor
     */
    public function __construct(){

        $this->atoms = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getName(): string {

        return $this->name;

    }

    /**
     * @return bool
     */
    public function isVisible(): bool
    {
        return $this->visible;
    }

	/**
	 * @return bool
	 */
	public function isLogStream(): bool
	{
		return $this->logStream;
	}

	/**
	 * @return bool
	 */
	public function isLogDb(): bool
	{
		return $this->logDb;
	}

	/**
	 * @return bool
	 */
	public function isLogFile(): bool
	{
		return $this->logFile;
	}
}