<?php

declare(strict_types=1);

namespace App\Entity\Device;

use App\Entity\Types\LivenessMisscount;
use App\Entity\Types\LivenessTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_stats')]
#[ORM\Entity]
class DeviceStats
{

    final public const ENTITY_TABLE_NAME = 'device_stats';

    /**
     * @var int
     */
    #[ORM\Column(name: 'id_device', type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private readonly int $id;

    /**
     * @var LivenessTime
     */
    #[ORM\ManyToOne(targetEntity: LivenessTime::class, inversedBy: 'devicesStats')]
    #[ORM\JoinColumn(name: 'livetime_class')]
    public LivenessTime $liveTime;

    /**
     * @var LivenessMisscount
     */
    #[ORM\ManyToOne(targetEntity: LivenessMisscount::class, inversedBy: 'devicesStats')]
    #[ORM\JoinColumn(name: 'livemiss_class')]
    public LivenessMisscount $liveMissCount;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'timeskew', type: Types::INTEGER, nullable: true)]
    public ?int $timeSkew = null;

    /**
     * @var float|null
     */
    #[ORM\Column(type: Types::FLOAT, nullable: true)]
    public ?float $voltage = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $temperature = null;

    /**
     * @var DeviceSyncStatus
     */
    #[ORM\ManyToOne(targetEntity: DeviceSyncStatus::class, inversedBy: 'devicesStatus')]
    #[ORM\JoinColumn(name: 'sync')]
    public DeviceSyncStatus $syncStatus;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public int $uptime;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'mem_total', type: Types::INTEGER, nullable: true)]
    public ?int $memoryTotal = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'mem_avail', type: Types::INTEGER, nullable: true)]
    public ?int $memoryAvailable = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $processes = null;

    /**
     * @var int|null
     */
    #[ORM\Column(name: 'root_avail', type: Types::INTEGER, nullable: true)]
    public ?int $rootSpaceDiskAvailable = null;

    /**
     * @var float|null
     */
    #[ORM\Column(type: Types::FLOAT, nullable: true)]
    public ?float $loadavg1 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(type: Types::FLOAT, nullable: true)]
    public ?float $loadavg5 = null;

    /**
     * @var float|null
     */
    #[ORM\Column(type: Types::FLOAT, nullable: true)]
    public ?float $loadavg15 = null;

	#[ORM\Column(type: Types::STRING, length: 16, nullable: true)]
	public ?string $simIpaddr  = null;

	#[ORM\Column(type: Types::SMALLINT, length: 5, nullable: true)]
	public ?int $simIpmask  = null;

	#[ORM\Column(type: Types::STRING, length: 48, nullable: true)]
	public ?string $simIp6addr  = null;

	#[ORM\Column(type: Types::SMALLINT, length: 5, nullable: true)]
	public ?int $simIp6pref  = null;

    /**
     * @var \DateTime
     */
    #[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $lastReboot;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $rebootCounter = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $signalStrength = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    public ?int $signalQuality = null;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return LivenessTime
     */
    public function getLiveTime(): LivenessTime {

        return $this->liveTime;

    }

    /**
     * @return LivenessMisscount
     */
    public function getLiveMissCount(): LivenessMisscount {

        return $this->liveMissCount;

    }

    /**
     * @return int|null
     */
    public function getTimeSkew(): ?int {

        return $this->timeSkew;

    }

    /**
     * @return float|null
     */
    public function getVoltage(): ?float{

        return $this->voltage;

    }

    /**
     * @return int|null
     */
    public function getTemperature(): ?int {

        return $this->temperature;

    }

    /**
     * @return DeviceSyncStatus
     */
    public function getSyncStatus(): DeviceSyncStatus {

        return $this->syncStatus;

    }

    /**
     * @return void
     */
    public function setSyncStatus(DeviceSyncStatus $syncStatus): void {

        $this->syncStatus = $syncStatus;

    }

    /**
     * @return int|null
     */
    public function getUptime(): ?int {

        return $this->uptime;

    }

    /**
     * @return int|null
     */
    public function getMemoryTotal(): ?int {

        return $this->memoryTotal * 1024;

    }

    /**
     * @return int|null
     */
    public function getMemoryAvailable(): ?int {

        return $this->memoryAvailable * 1024;

    }

    /**
     * @return int|null
     */
    public function getRootSpaceDiskAvailable(): ?int {

        return $this->rootSpaceDiskAvailable * 1024;

    }

}