<?php

declare(strict_types=1);

namespace App\Entity\Product;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'product_versions')]
#[ORM\Entity]
class ProductVersion implements \Stringable
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean')]
    public bool $actual;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer')]
    public int $versionMajor;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer')]
    public int $versionMinor;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer')]
    public int $versionPatchlevel;

    /**
     * @var string
     */
    #[ORM\Column(name: 'version_string', type: 'string', length: 16, nullable: false)]
    public string $version;

    /**
     * @var string
     */
    #[ORM\Column(name: 'description', type: 'text', nullable: true, options: ['default' => null])]
    public string $description;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean')]
    public bool $major;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean')]
    public bool $beta;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean')]
    public bool $notification;

    /**
     * @var bool
     */
    #[ORM\Column(name: 'force_display', type: 'boolean')]
    public bool $forceDisplay;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'release_date', type: 'datetime')]
    public \DateTime $releaseDate;


    /**
     * OsVersion constructor.
     */
    public function __construct() {

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return bool
     */
    public function isActual(): bool
    {
        return $this->actual;
    }

    /**
     * @return int
     */
    public function getVersionMajor(): int
    {
        return $this->versionMajor;
    }

    /**
     * @return int
     */
    public function getVersionMinor(): int
    {
        return $this->versionMinor;
    }

    /**
     * @return int
     */
    public function getVersionPatchlevel(): int
    {
        return $this->versionPatchlevel;
    }

    /**
     * @return mixed
     */
    public function getVersion(): string {

        return $this->version;

    }

    /**
     * @return bool
     */
    public function isMajor(): bool
    {
        return $this->major;
    }

    /**
     * @return bool
     */
    public function isBeta(): bool
    {
        return $this->beta;
    }

    /**
     * @return string
     */
    public function getDescription(): string {

        return $this->description;

    }

    /**
     * @return bool
     */
    public function getNotification(): bool {

        return $this->notification;

    }

    /**
     * @return bool
     */
    public function getForceDisplay(): bool {

        return $this->forceDisplay;

    }

    public function __toString(): string {

        return $this->getDescription();

    }

}