<?php

namespace App\Service;

use App\Repository\HistoryRepository;
use Doctrine\DBAL\Exception;

class History
{

    private HistoryRepository $historyRepository;

    /**
     * @param HistoryRepository $historyRepository
     */
    public function __construct(HistoryRepository $historyRepository){

        $this->historyRepository = $historyRepository;
    }

    /**
     * @param int $historyType
     * @return array
     * @throws Exception
     */
    public function getHistoryTimeLegend(int $historyType){

        $result = $this->historyRepository->getHistoryTimeSlots($historyType);

        $historyData = [];

        foreach ($result as $item){

            $historyData[$item['timeslot']][] = [
                'description' => $item['description'],
                'amount' => $item['amount'],
            ];

        }

        $legend = [];

        foreach ($historyData as $timeslot){

            $size = count($timeslot);

            foreach ($timeslot as $key => $item){

                if($key === 0){

                    $legend[] = $item['amount'] . $item['description'];

                }else{

                    $legend[] = $item['amount'] * ($key + 1) . $item['description'];

                }

            }

        }

       return $legend;

    }

    /**
     * @param int $historyType
     * @param int $deviceId
     * @return array
     * @throws Exception
     */
    public function getHistoryDataForDevice(int $historyType, int $deviceId){

        //todo zjistit délku profilu, kolik mají data prvků

        $result = $this->historyRepository->getHistoryDataByDeviceId($historyType, $deviceId);

        $data = [];

        foreach ($result as $type){

            $dataValues = array_values(
                array_filter($type, function ($value, $key){
                    return str_starts_with($key, 'data');
                    }, ARRAY_FILTER_USE_BOTH)
            );

            $data[$type['description']] = [
                'description' => $type['description'],
                'type' => $type['graph_type'],
                'unit' => $type['unit'],
                'min' => $type['usual_min'],
                'max' => $type['usual_max'],
                'data' => $dataValues,
            ];

        }

        return $data;

    }

}