<?php

namespace App\Form\System;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class SystemStatusType extends AbstractType
{
    private const SERVICE_STATUS_ACTIVE = 'active';
    private const SERVICE_STATUS_INACTIVE = 'inactive';

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $dgStatus = str_replace("\n", "", $options['data']['dgStatus']);
        $snmpGatewayStatus = str_replace("\n", "", $options['data']['snmpGatewayStatus']);
		$isSnmpServiceEnabled = $options['data']['isSnmpServiceEnabled'];

        if ($dgStatus === self::SERVICE_STATUS_ACTIVE) {
            $builder->add('dgRestart', SubmitType::class, [
                'label' => '<i class="fas fa-retweet"></i> Restart',
                'label_html' => true
            ]);
        } else {
            $builder->add('dgStart', SubmitType::class, [
                'label' => '<i class="fas fa-play"></i> Start',
                'label_html' => true
            ]);
        }

		if($isSnmpServiceEnabled) {

			if ($snmpGatewayStatus === self::SERVICE_STATUS_ACTIVE) {
				$builder->add('snmpGatewayRestart', SubmitType::class, [
					'label' => '<i class="fas fa-retweet"></i> Restart',
					'label_html' => true
				]);
				$builder->add('snmpGatewayStop', SubmitType::class, [
					'label' => '<i class="fas fa-stop"></i> Stop',
					'label_html' => true
				]);
			} else {
				$builder->add('snmpGatewayStart', SubmitType::class, [
					'label' => '<i class="fas fa-play"></i> Start',
					'label_html' => true
				]);
			}

		}

        $builder->add('tunnelCleanup', SubmitType::class, [
            'label' => '<i class="fas fa-route"></i> Tunnel slot cleanup + Restart',
            'label_html' => true
        ]);

    }

}
