<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class DeviceCustomModuleDownloadType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        /** @var Device $device */
        $device = $options['data']['device'];

        $builder
            ->add('deviceId', HiddenType::class, array(
                'data' => $device->getDevId(),
            ))
            ->add('deviceType', HiddenType::class, array(
                'data' => $device->getDevType()->getId(),
            ))
            ->add('download', SubmitType::class, [
                'label' => '<i class="fas fa-download"></i> Download preset agent',
                'label_html' => true,
                'attr' => ['class' => 'btn-primary btn-xs']])
        ;
    }
}
