<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class ConfigProfileCloneDeviceToType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        /** @var Device $device */
        $devicesToClonedTo = $options['data']['devicesToClonedTo'];
        $devicesToCloneTo = $options['data']['devicesToCloneTo'];
        $isCloned = $options['data']['isCloned'];

        $selectedItems = [];

        foreach ($devicesToClonedTo as $item) {
            $selectedItems[] = $item->getId();
        }

        $choices = [];
        $choicesAttr = [];

        foreach ($devicesToCloneTo as $item) {

            $choices[$item['devid']] = $item['id_device'];
            $choicesAttr[$item['devid']] = ['data-description' => $item['name']];

        }

        $builder
            ->add('devices', ChoiceType::class ,array(
                'choices' => $choices,
                'choice_attr' => $choicesAttr,
                'placeholder' => 'Select a Device to clone to',
                'multiple' => true,
                'required' => false,
                'data' => $selectedItems,

            ))
            ->add('save', SubmitType::class, ['label' => 'Set ',
                'block_prefix' => 'modal_footer'])
        ;
        if($isCloned){

            $builder->add('no_clone', SubmitType::class, ['label' => 'Remove cloning']);

        }


    }

}