#!/bin/bash

FUNCS="deploy_funcs.sh"

command -v dirname >/dev/null 2>&1 || {
	echo "\"dirname\" command not available, bailing out." >&2
	exit 1
}

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR"/"$FUNCS" || {
	echo "Unable to read deploy functions, exiting..." >&2
	exit 1
}

BASEDEFS="base_defs"
read_defs || {
	echo "Unable to read configuration, is application installed?" >&2
	exit 1
}

MYTMPDIR="/tmp/${SHORTNAME}_logs_$$"
METR=metrics.txt
MYOPWD=$(pwd)
mkdir "$MYTMPDIR" || fail_fat "Unable to create log directory $MYTMPDIR"
cd "$MYTMPDIR" || fail_fat "Unable to cd to $MYTMPDIR"
mkdir ${SHORTNAME}
cp -r $SRVDIR/logs $SHORTNAME/
mkdir gui
cp -r $SRVDIR/var/log gui/
mkdir notifier
cp -r $BINDIR/notifier/var/log notifier/
cp $BINDIR/buildtag.txt .
mysqldump --user="$APPUSER" --password="$DBPASS" $DWARFG_DBN log_events >event_log.sql
mysqldump --user="$APPUSER" --password="$DBPASS" $DWARFG_DBN product_conf >product_conf.sql
mysqldump --user="$APPUSER" --password="$DBPASS" $DWARFG_DBN vdevices >vdevices.sql
curl http://127.0.0.1:$DWARFG_PORT/g/dashboard >dashboard.datadump
for i in / "$BINDIR" "$SRVDIR" ; do
	echo "stats for $i" >>"$METR"
	df "$i" >>$METR
	df -i "$i" >>$METR
done
echo "ls -laR $DWARFG_CACHE" >>$METR
ls -laR $DWARFG_CACHE >>$METR
echo "md5sum $BINDIR/*" >>$METR
md5sum "$BINDIR"/* >>$METR
echo "free + uptime" >>$METR
free >>$METR
uptime >>$METR
echo "/etc/issue.net" >>$METR
cat /etc/issue.net >>$METR
echo "/etc/debian_version" >>$METR
cat /etc/debian_version >>$METR
journalctl -u "$DWARFG_NAM" --since "7 days ago" >>journalctl_"$DWARFG_NAM".log
tar cf apache_cfg.tar /etc/apache2/sites-available /etc/apache2/sites-enabled
cp $BINDIR/apache* .
mkdir systemd.cfg
cp /etc/systemd/system/"$SHORTNAME"* systemd.cfg/
cd "$MYOPWD"
tar czf "$DWARFG_DIR_WEB/${SHORTNAME}_logspack.tgz" "$MYTMPDIR"
rm -rf "$MYTMPDIR"
echo "$DWARFG_DIR_WEB/${SHORTNAME}_logspack.tgz"
exit 0
