# Dependencies used by Sshwifty

Sshwifty uses many third-party components. Those components is required in order
for Sshwifty to function.

A list of used components can be found inside `package.json` and `go.mod` file.

Major dependencies includes:

## For front-end application

- [Vue](https://vuejs.org), Licensed under MIT license
- [Babel](https://babeljs.io/), Licensed under MIT license
- [XTerm.js](https://xtermjs.org/), Licensed under MIT license
- [normalize.css](https://github.com/necolas/normalize.css), Licensed under MIT license
- [Roboto font](https://en.wikipedia.org/wiki/Roboto), Licensed under Apache license
  Packaged by [Christian Hoffmeister](https://github.com/choffmeister/roboto-fontface-bower), Licensed under Apache 2.0
- [iconv-lite](https://github.com/ashtuchkin/iconv-lite), Licensed under MIT license
- [buffer](https://github.com/feross/buffer), Licensed under MIT license
- [fontfaceobserver](https://github.com/bramstein/fontfaceobserver), [View license](https://github.com/bramstein/fontfaceobserver/blob/master/LICENSE)
- [Hack Font](https://github.com/source-foundry/Hack), [View license](https://github.com/source-foundry/Hack/blob/master/LICENSE.md)
- [Nerd Fonts](https://www.nerdfonts.com/), packaged by [@azurity/pure-nerd-font](http://github.com/azurity/pure-nerd-font)
  includes icons from following fonts:
  - [Powerline Extra Symbols](https://github.com/ryanoasis/powerline-extra-symbols), Licensed under MIT license
  - [Font Awesome](https://github.com/FortAwesome/Font-Awesome), [View license](https://github.com/FortAwesome/Font-Awesome/blob/6.x/LICENSE.txt)
  - [Font Awesome Extension](https://github.com/AndreLZGava/font-awesome-extension), Licensed under MIT license
  - [Material Design Icons](https://github.com/Templarian/MaterialDesign), [View license](https://github.com/Templarian/MaterialDesign/blob/master/LICENSE)
  - [Weather Icons](https://github.com/erikflowers/weather-icons), Licensed under SIL OFL 1.1
  - [Devicons](https://github.com/vorillaz/devicons), Licensed under MIT license
  - [Octicons](https://github.com/primer/octicons), Licensed under MIT license
  - [Codicons](https://github.com/microsoft/vscode-codicons), Licensed under MIT License
  - [Font Logos (Formerly Font Linux)](https://github.com/Lukas-W/font-logos), Licensed under Unlicense license 
  - [Pomicons](https://github.com/gabrielelana/pomicons), Licensed under OFL-1.1 license
  - ... and more, see [full list](https://github.com/ryanoasis/nerd-fonts/tree/master/src/glyphs)

## For back-end application

- [Go programming language](https://golang.org), [View license](https://github.com/golang/go/blob/master/LICENSE)
- `github.com/gorilla/websocket`, Licensed under BSD-2-Cause license
- `golang.org/x/net/proxy` [View license](https://github.com/golang/net/blob/master/LICENSE)
- `golang.org/x/crypto`, [View license](https://github.com/golang/crypto/blob/master/LICENSE)
