<?php

declare(strict_types=1);

namespace App\Controller\Admin\System;

use App\Form\SystemStatusType;
use App\Service\Command;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\Response;

class StatusController extends Controller
{

    public function __construct(private readonly Command $commandService)
    {
    }

    /**
     * @return Response
     */
    #[Route(path: '/admin/system/status', name: 'admin_system_status')]
    public function default(Request $request): Response {

        $status = $this->commandService->getServiceStatus();

        $form = $this->createForm(SystemStatusType::class, ['status' => $status]);

        $form->handleRequest($request);

        if($form->has('restart') && $form->get('restart')->isClicked()){

            try{

                $isRestarted = $this->commandService->restartService();

            }catch (ProcessFailedException $exception){

                $this->addFlash(
                    'danger',
                    'Service restart failed. Reason: ' . $exception->getMessage()
                );

                return $this->redirectToRoute('admin_system_status');

            }

            if (!$isRestarted) {

                $this->addFlash(
                    'danger',
                    'Service restart failed.'
                );

                return $this->redirectToRoute('admin_system_status');
            }

            $this->addFlash(
                'success',
                'Service was restarted.'
            );

            return $this->redirectToRoute('admin_system_status');

        }elseif($form->has('start') && $form->get('start')->isClicked()){

            try{

                $isStarted = $this->commandService->startService();

            }catch (ProcessFailedException $exception){

                $this->addFlash(
                    'danger',
                    'Service start failed. Reason: ' . $exception->getMessage()
                );

                return $this->redirectToRoute('admin_system_status');

            }

            if (!$isStarted) {
                //throw new ProcessFailedException($process);
                $this->addFlash(
                    'danger',
                    'Service start failed.'
                );

                return $this->redirectToRoute('admin_system_status');
            }

            $this->addFlash(
                'success',
                'Service was started.'
            );

            return $this->redirectToRoute('admin_system_status');

        }

        return $this->render("system/status.html.twig", [
            'form' => $form->createView(),
            'status' => trim($status),
        ]);

    }

}