<?php

namespace App\Datatables\Column;

use Sg\DatatablesBundle\Datatable\Column\Column;

class CustomDeviceFreshnessColumn extends Column
{
    /**
     * {@inheritdoc}
     */
    public function renderSingleField(array &$row)
    {

        $status = $row['stats']['liveMissCount']['description'];
        $statusId = $row['stats']['liveMissCount']['id'];

        if($statusId <= 2 ){
            $color = 'green';
        }elseif($statusId >= 5){
            $color = 'red';
        }else{
            $color = 'yellow';
        }

        $row['stats']['liveMissCount']['description'] = '<div style="font-size: 11px;"><i class="fa fa-circle '.$color.'" aria-hidden="true"></i> ' .$status. '</div>';

        return parent::renderSingleField($row);
    }

}