<?php

namespace App\Repository;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;

class HistoryRepository
{

    public const DEFAULT_HISTORY_TYPE = 1;
    public const HISTORY_BIT_TYPE_AVERAGE = 1;
    public const HISTORY_BIT_TYPE_RUNNNING_AVERAGE = 2;

    /**
     * @var Connection
     */
    protected Connection $conn;

    /**
     * @param Connection $conn
     */
    public function __construct(Connection $conn){

        $this->conn = $conn;

    }

    /**
     * @param int $historyType
     * @return array
     * @throws Exception
     */
    public function getHistoryTimeSlots(int $historyType): array{

        $sql = 'SELECT * FROM device_history_type_map htm
                join device_history_timeslot ht on ht.id = htm.timeslot
                join typetable_time_units tu on tu.id = ht.unit
                where htm.history_type = :historyType and htm.bit_type = :bitType and visible = :visible;';

        //create the prepared statement, by getting the doctrine connection
        $stmt = $this->conn->prepare($sql);
		$stmt->bindValue(':historyType', $historyType);
		$stmt->bindValue(':bitType', 1);
		$stmt->bindValue(':visible', 1);
		return $stmt->executeQuery()->fetchAllAssociative();

    }

    /**
     * @param int $historyType
     * @param int $deviceId
     * @return array
     * @throws Exception
     */
    public function getHistoryDataByDeviceId(int $historyType, int $deviceId): array{

        $sql = 'SELECT a.*, vd.description, vd.unit, vd.usual_min, vd.usual_max, vt.name, 
                ht.description as history_type, gt.description as graph_type
                FROM device_history a 
                join device_history_value_descriptions vd on vd.id = a.value_id
                join typetable_value_types vt on vt.id = vd.history_type
                join device_history_types ht on ht.id = a.history_type
                join graph_type_selections gts on gts.id = vd.default_graph_type_selection
                join graph_types as gt on gt.id = gts.graph_type
                where ht.id = :historyType and a.id_device = :deviceId
                order by vd.default_ui_order';

        //create the prepared statement, by getting the doctrine connection
        $stmt = $this->conn->prepare($sql);
		$stmt->bindValue(':historyType', $historyType);
		$stmt->bindValue(':deviceId', $deviceId);
        $result = $stmt->executeQuery();
        $resultData = $result->fetchAllAssociative();

        $historyTimeMapIndexToRemove = $this->getHistoryTimeMap(self::DEFAULT_HISTORY_TYPE, self::HISTORY_BIT_TYPE_RUNNNING_AVERAGE);

        //Update name of the keys to remove
        foreach ($historyTimeMapIndexToRemove as &$itemIndexRemove) {
           $itemIndexRemove = 'data_' . $itemIndexRemove;
        }

        foreach ($resultData as &$dataItem){

            foreach ($dataItem as $key => $data){

                if(in_array($key, $historyTimeMapIndexToRemove, true)){

                    unset($dataItem[$key]);

                }

            }

        }

        return $resultData;

    }

    /**
     * @param int $historyType
     * @param int $bitType
     * @return array
     * @throws Exception
     */
    public function getHistoryTimeMap(int $historyType, int $bitType): array{

        $sql = 'SELECT * FROM device_history_type_map htm
                where htm.history_type = :historyType and htm.bit_type = :bitType';

        //create the prepared statement, by getting the doctrine connection
		$stmt = $this->conn->prepare($sql);
		$stmt->bindValue(':historyType', $historyType);
		$stmt->bindValue(':bitType', $bitType);
		return $stmt->executeQuery()->fetchFirstColumn();

    }

}