#!/bin/bash

FUNCS="deploy_funcs.sh"

command -v dirname >/dev/null 2>&1 || {
	echo "\"dirname\" command not available, bailing out." >&2
	exit 1
}

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR"/"$FUNCS" || {
	echo "Unable to read deploy functions, exiting..." >&2
	exit 1
}

BASEDEFS="base_defs"
read_defs || {
	echo "Unable to read configuration, is application installed?" >&2
	exit 1
}

tmpdir_fname="${SHORTNAME}_dbdumps_$$"
tmpdir_base="/tmp"
tmpdir_fpath="${tmpdir_base}/$tmpdir_fname"
MYOPWD=$(pwd)
dbdump_fname_base="dbdump_mangled_${DWARFG_DBN}_$(date "+%F_%H-%M-%S")"
dbdump_fname="${dbdump_fname_base}.sql"
dbdump_fpath_archive="/tmp/${dbdump_fname_base}.tgz"
mkdir "$tmpdir_fpath" || fail_fat "Unable to create log directory $tmpdir_fpath"
cd "$tmpdir_fpath" || fail_fat "Unable to cd to $tmpdir_fpath"
{ mysql --user="$APPUSER" --password="$DBPASS" "$DWARFG_DBN" <<"EOF"
DROP TABLE IF EXISTS user_mangled;
CREATE TABLE user_mangled LIKE user;
INSERT INTO user_mangled SELECT * FROM user;
UPDATE user_mangled SET password = '$2y$13$Pc11WqeO0phxQHdxr5B.KesH8xhkPLY5z5s1Nc6B6hZ42PRciJnHW';
DROP TABLE IF EXISTS auth_profiles_mangled;
CREATE TABLE auth_profiles_mangled LIKE auth_profiles;
INSERT INTO auth_profiles_mangled SELECT * FROM auth_profiles;
UPDATE auth_profiles_mangled SET ssh_pwd = NULL;
UPDATE auth_profiles_mangled SET ssh_key = NULL;
EOF
} || fail_fat "Unable to prepare mangled tables"
mysqldump --user="$APPUSER" --password="$DBPASS" "$DWARFG_DBN" --ignore-table="${DWARFG_DBN}.auth_profiles" --ignore-table="${DWARFG_DBN}.user" >"${dbdump_fname}" || fail_fat "DBdump failed (check free space and previous errors)."
{ mysql --user="$APPUSER" --password="$DBPASS" "$DWARFG_DBN" <<"EOF"
DROP TABLE user_mangled;
DROP TABLE auth_profiles_mangled;
EOF
} || fail_nof "Failed to drop mangled tables from DB."
dbdump_fname_p1="${dbdump_fname}_proc"
dbdump_fname_p2="${dbdump_fname}_res"
mv "$dbdump_fname" "$dbdump_fname_p1" || fail_fat "Failed to rename DBdump"
for table in user auth_profiles; do
	for pat in DROP CREATE LOCK INSERT; do
		sed "s/^\($pat.*\)${table}_mangled\(.*\)/\1${table}\2/" "$dbdump_fname_p1" >"$dbdump_fname_p2" && mv "$dbdump_fname_p2" "$dbdump_fname_p1" || fail_fat "Failed to update mangled table $table pattern $pat"
	done
	for pat in "ALTER TABLE"; do
		sed "s/\($pat.*\)${table}_mangled\(.*KEYS.*\)/\1${table}\2/" "$dbdump_fname_p1" >"$dbdump_fname_p2" && mv "$dbdump_fname_p2" "$dbdump_fname_p1" || fail_fat "Failed to update mangled table $table KEYS pattern $pat"
	done
done
mv "$dbdump_fname_p1" "$dbdump_fname" || fail_fat "Failed to rename processed dump to proper filename."
cd "$tmpdir_base" || fail_fat "Cannot cd to $tmpdir_base"
tar czf "$dbdump_fpath_archive" "$tmpdir_fname" || fail_fat "Failed to create archive (check free space and errors)."
rm -rf "$tmpdir_fname" || fail_nof "Failed to remove temporary directory $tmpdir_fname"
echo "${dbdump_fpath_archive}"
cd "$MYOPWD" || fail_fat "Failed to cd to $MYOPWD"
exit 0
