<?php

namespace App\Form\ConfigProfile;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\File;
use Symfony\Component\Validator\Constraints\NotBlank;

class ConfigProfileFileUploadType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {

        $builder

			->add('label', TextType::class, [
				'required' => false,
				'block_prefix' => 'modal_body',
			])

			->add('profile', FileType::class, [
				'label' => 'Config profile file (.xlsx file)',

				// unmapped means that this field is not associated to any entity property
				'mapped' => false,

				// make it optional so you don't have to re-upload the PDF file
				// every time you edit the details
				'required' => true,

				// unmapped fields can't define their validation using annotations
				// in the associated entity, so you can use the PHP constraint classes
				'constraints' => [
					new NotBlank(null, 'Select the valid Config Profile file.'),
					new File([
						'maxSize' => '10M',
						/*'mimeTypes' => [
							'application/octet-stream',
						],*/
						'mimeTypesMessage' => 'Please upload a valid Profile file.',
					])
				],
				'block_prefix' => 'modal_body'
			])

			->add('upload', SubmitType::class, [
				'label' => '<i class="fa fa-upload" aria-hidden="true"></i> Upload',
				'label_html' => true,
				'block_prefix' => 'modal_footer',
			]);

    }

}