<?php

declare(strict_types=1);

namespace Kreyu\Bundle\DataTableBundle\Tests;

trait ReflectionTrait
{
    private function getPrivatePropertyValue(object $object, string $property): mixed
    {
        $reflection = new \ReflectionProperty($object, $property);
        $reflection->setAccessible(true);

        return $reflection->getValue($object);
    }

    private function setPrivatePropertyValue(object $object, string $property, mixed $value): void
    {
        $reflection = new \ReflectionProperty($object, $property);
        $reflection->setAccessible(true);
        $reflection->setValue($object, $value);
    }
}
